USE BD_Air_France;

IF OBJECT_ID('dbo.T_vols_catalogue_vlc','U') IS NOT NULL
   DROP TABLE dbo.T_vols_catalogue_vlc;
GO
IF OBJECT_ID('dbo.T_aeroport_aer','U') IS NOT NULL
   DROP TABLE dbo.T_aeroport_aer;
GO

CREATE TABLE T_aeroport_aer
(aer_IATA         VARCHAR(3),
 aer_OACI         VARCHAR(6) NOT NULL,
 aer_nom          VARCHAR(50) NOT NULL,
 CONSTRAINT PK_aer      PRIMARY KEY(aer_IATA),
 CONSTRAINT UK_aer_OACI UNIQUE(aer_OACI));

-- le type TIME n'est support qu' partir de la version 2008
CREATE TABLE T_vols_catalogue_vlc
(vlc_num_vol      VARCHAR(8),
 vlc_h_dep        TIME(0),
 vlc_h_arr        TIME(0),
 aer_dep          VARCHAR(3) NOT NULL,
 aer_arr          VARCHAR(3) NOT NULL,
 CONSTRAINT PK_vlc         PRIMARY KEY(vlc_num_vol),
 CONSTRAINT FK_vlc_aer_dep FOREIGN KEY(aer_dep)
                           REFERENCES T_aeroport_aer(aer_IATA),
 CONSTRAINT FK_vlc_aer_arr FOREIGN KEY(aer_arr)
                           REFERENCES T_aeroport_aer(aer_IATA),
 CONSTRAINT CK_vlc_dep_arr CHECK (aer_dep != aer_arr));